/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.BlockMolten;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.devices.BlockBloomery;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.TEBloom;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class TEBloomery
extends TETickableInventory
implements ITickable {
    private static final Vec3i OFFSET_INTERNAL = new Vec3i(1, 0, 0);
    private static final Vec3i OFFSET_EXTERNAL = new Vec3i(-1, 0, 0);
    protected final List<ItemStack> oreStacks = new ArrayList<ItemStack>();
    protected final List<ItemStack> fuelStacks = new ArrayList<ItemStack>();
    protected int maxFuel = 0;
    protected int maxOre = 0;
    protected long litTick;
    protected BlockPos internalBlock = null;
    protected BlockPos externalBlock = null;
    protected BloomeryRecipe cachedRecipe = null;

    public TEBloomery() {
        super(0);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.oreStacks.clear();
        NBTTagList ores = tag.func_150295_c("ores", 10);
        for (int i = 0; i < ores.func_74745_c(); ++i) {
            this.oreStacks.add(new ItemStack(ores.func_150305_b(i)));
        }
        this.fuelStacks.clear();
        NBTTagList fuels = tag.func_150295_c("fuels", 10);
        for (int i = 0; i < fuels.func_74745_c(); ++i) {
            this.fuelStacks.add(new ItemStack(fuels.func_150305_b(i)));
        }
        this.litTick = tag.func_74763_f("litTick");
        super.func_145839_a(tag);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagList ores = new NBTTagList();
        for (ItemStack stack : this.oreStacks) {
            ores.func_74742_a((NBTBase)stack.serializeNBT());
        }
        tag.func_74782_a("ores", (NBTBase)ores);
        NBTTagList fuels = new NBTTagList();
        for (ItemStack stack : this.fuelStacks) {
            fuels.func_74742_a((NBTBase)stack.serializeNBT());
        }
        tag.func_74782_a("fuels", (NBTBase)fuels);
        tag.func_74772_a("litTick", this.litTick);
        return super.func_189515_b(tag);
    }

    @Override
    public void onBreakBlock(World worldIn, BlockPos pos, IBlockState state) {
        this.dumpItems();
        super.onBreakBlock(this.field_145850_b, pos, state);
    }

    public ImmutableList<ItemStack> getFuelStacks() {
        return ImmutableList.copyOf(this.fuelStacks);
    }

    public ImmutableList<ItemStack> getOreStacks() {
        return ImmutableList.copyOf(this.oreStacks);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue() && this.getRemainingTicks() <= 0L) {
                if (this.cachedRecipe == null && !this.oreStacks.isEmpty()) {
                    this.cachedRecipe = BloomeryRecipe.get(this.oreStacks.get(0));
                    if (this.cachedRecipe == null) {
                        this.dumpItems();
                    }
                }
                if (this.cachedRecipe != null) {
                    this.field_145850_b.func_175656_a(this.getInternalBlock(), BlocksTFC.BLOOM.func_176223_P());
                    TEBloom te = Helpers.getTE((IBlockAccess)this.field_145850_b, this.getInternalBlock(), TEBloom.class);
                    if (te != null) {
                        te.setBloom(this.cachedRecipe.getOutput(this.oreStacks));
                    }
                }
                this.oreStacks.clear();
                this.fuelStacks.clear();
                this.cachedRecipe = null;
                this.updateSlagBlock(false);
                state = state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
                this.func_70296_d();
            }
            int newMaxItems = BlockBloomery.getChimneyLevels(this.field_145850_b, this.getInternalBlock()) * 8;
            EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            if (!BlocksTFC.BLOOMERY.isFormed(this.field_145850_b, this.getInternalBlock(), direction)) {
                newMaxItems = 0;
            }
            this.maxFuel = newMaxItems;
            this.maxOre = newMaxItems;
            boolean turnOff = false;
            while (this.maxOre < this.oreStacks.size()) {
                turnOff = true;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.getExternalBlock().func_177958_n(), (double)this.getExternalBlock().func_177956_o(), (double)this.getExternalBlock().func_177952_p(), (ItemStack)this.oreStacks.get(0));
                this.oreStacks.remove(0);
                this.markForSync();
            }
            while (this.maxFuel < this.fuelStacks.size()) {
                turnOff = true;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.getExternalBlock().func_177958_n(), (double)this.getExternalBlock().func_177956_o(), (double)this.getExternalBlock().func_177952_p(), (ItemStack)this.fuelStacks.get(0));
                this.fuelStacks.remove(0);
                this.markForSync();
            }
            if (turnOff && ((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
                state = state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
            }
            if (!BlocksTFC.BLOOMERY.canGateStayInPlace(this.field_145850_b, this.field_174879_c, direction.func_176740_k())) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
                return;
            }
            if (!this.isInternalBlockComplete() && !this.fuelStacks.isEmpty()) {
                this.dumpItems();
            }
            if (this.isInternalBlockComplete()) {
                int oldFuel = this.fuelStacks.size();
                int oldOre = this.oreStacks.size();
                this.addItemsFromWorld();
                if (oldFuel != this.fuelStacks.size() || oldOre != this.oreStacks.size()) {
                    this.markForSync();
                }
            }
            this.updateSlagBlock((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT));
        }
    }

    public void onLoad() {
        this.getExternalBlock();
    }

    public long getRemainingTicks() {
        return (long)ConfigTFC.Devices.BLOOMERY.ticks - (CalendarTFC.PLAYER_TIME.getTicks() - this.litTick);
    }

    public boolean canIgnite() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.fuelStacks.size() < this.oreStacks.size() || this.oreStacks.isEmpty()) {
            return false;
        }
        return this.isInternalBlockComplete();
    }

    public void onIgnite() {
        this.litTick = CalendarTFC.PLAYER_TIME.getTicks();
    }

    public BlockPos getInternalBlock() {
        if (this.internalBlock == null) {
            EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            this.internalBlock = this.field_174879_c.func_177981_b(OFFSET_INTERNAL.func_177956_o()).func_177967_a(direction, OFFSET_INTERNAL.func_177958_n()).func_177967_a(direction.func_176746_e(), OFFSET_INTERNAL.func_177952_p());
        }
        return this.internalBlock;
    }

    public BlockPos getExternalBlock() {
        if (this.externalBlock == null) {
            EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            this.externalBlock = this.field_174879_c.func_177981_b(OFFSET_EXTERNAL.func_177956_o()).func_177967_a(direction, OFFSET_EXTERNAL.func_177958_n()).func_177967_a(direction.func_176746_e(), OFFSET_EXTERNAL.func_177952_p());
        }
        return this.externalBlock;
    }

    protected void dumpItems() {
        for (int i2 = 1; i2 < 4; ++i2) {
            if (this.field_145850_b.func_180495_p(this.getInternalBlock().func_177981_b(i2)).func_177230_c() != BlocksTFC.MOLTEN) continue;
            this.field_145850_b.func_175698_g(this.getInternalBlock().func_177981_b(i2));
        }
        this.oreStacks.forEach(i -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.getExternalBlock().func_177958_n(), (double)this.getExternalBlock().func_177956_o(), (double)this.getExternalBlock().func_177952_p(), (ItemStack)i));
        this.fuelStacks.forEach(i -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.getExternalBlock().func_177958_n(), (double)this.getExternalBlock().func_177956_o(), (double)this.getExternalBlock().func_177952_p(), (ItemStack)i));
    }

    protected boolean isInternalBlockComplete() {
        IBlockState inside = this.field_145850_b.func_180495_p(this.getInternalBlock());
        return inside.func_177230_c() == BlocksTFC.CHARCOAL_PILE && (Integer)inside.func_177229_b((IProperty)BlockCharcoalPile.LAYERS) >= 8;
    }

    protected void addItemsFromWorld() {
        if (this.cachedRecipe == null && !this.oreStacks.isEmpty()) {
            this.cachedRecipe = BloomeryRecipe.get(this.oreStacks.get(0));
            if (this.cachedRecipe == null) {
                this.dumpItems();
            }
        }
        block0: for (EntityItem entityItem : this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.getInternalBlock().func_177984_a(), this.getInternalBlock().func_177982_a(1, 4, 1)), EntitySelectors.field_94557_a)) {
            ItemStack stack = entityItem.func_92059_d();
            if (this.cachedRecipe == null) {
                this.cachedRecipe = BloomeryRecipe.get(stack);
            }
            if (this.cachedRecipe == null) continue;
            if (this.cachedRecipe.isValidInput(stack)) {
                if (this.oreStacks.size() < this.maxOre) {
                    this.func_70296_d();
                }
                while (this.oreStacks.size() < this.maxOre) {
                    this.oreStacks.add(stack.func_77979_a(1));
                    if (stack.func_190916_E() > 0) continue;
                    entityItem.func_70106_y();
                    continue block0;
                }
                continue;
            }
            if (!this.cachedRecipe.isValidAdditive(stack)) continue;
            if (this.fuelStacks.size() < this.maxFuel) {
                this.func_70296_d();
            }
            while (this.fuelStacks.size() < this.maxFuel) {
                this.fuelStacks.add(stack.func_77979_a(1));
                if (stack.func_190916_E() > 0) continue;
                entityItem.func_70106_y();
                continue block0;
            }
        }
    }

    protected void updateSlagBlock(boolean cooking) {
        int slag = this.fuelStacks.size() + this.oreStacks.size();
        int slagLayers = slag > 0 && slag < 4 ? 1 : slag / 4;
        for (int i = 1; i < 4; ++i) {
            if (slagLayers > 0) {
                if (slagLayers >= 4) {
                    slagLayers -= 4;
                    this.field_145850_b.func_175656_a(this.getInternalBlock().func_177981_b(i), BlocksTFC.MOLTEN.func_176223_P().func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(cooking)).func_177226_a((IProperty)BlockMolten.LAYERS, (Comparable)Integer.valueOf(4)));
                    continue;
                }
                this.field_145850_b.func_175656_a(this.getInternalBlock().func_177981_b(i), BlocksTFC.MOLTEN.func_176223_P().func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(cooking)).func_177226_a((IProperty)BlockMolten.LAYERS, (Comparable)Integer.valueOf(slagLayers)));
                slagLayers = 0;
                continue;
            }
            if (this.field_145850_b.func_180495_p(this.getInternalBlock().func_177981_b(i)).func_177230_c() != BlocksTFC.MOLTEN) continue;
            this.field_145850_b.func_175698_g(this.getInternalBlock().func_177981_b(i));
        }
    }
}

